﻿namespace Code6587EN.Ch02.ImportDesign
{
    using Microsoft.SharePoint;
    using Microsoft.SharePoint.Publishing;
    using System;
    using System.IO;

    /// <summary>
    /// Console Application to import and apply a Design Package
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            // Get the Site Collection in a Using statement.
            using (var site = new SPSite("http://sharepoint/sitecollection"))
            {
                // Get the root Site of the Site Collection in a Using statement.
                using (var web = site.RootWeb)
                {
                    // Get the file path
                    var filePath = "C:\\My Code Design-1.0.wsp";

                    // Get the file name from the path
                    var fileName = Path.GetFileName(filePath);

                    // Create a new Design Package Info object with the file name, an empty guid, the major version, and the minor version
                    var package = new DesignPackageInfo(fileName, Guid.Empty, 1, 0);

                    // Create a temporary folder to upload to
                    var tempFolderName = "temp_designupload" + Guid.NewGuid().ToString();
                    var tempFolder = web.RootFolder.SubFolders.Add(tempFolderName);

                    // Open the file and upload it to the temporary folder
                    var fileBinary = File.OpenRead(filePath);
                    var file = tempFolder.Files.Add(fileName, fileBinary, true);
                    fileBinary.Close();

                    // Install the Design Package
                    DesignPackage.Install(site, package, file.Url);

                    // Delete the temporary folder
                    tempFolder.Delete();
                }
            }

            // Wait for a key to be pressed before closing the application
            Console.WriteLine("Press Any Key to Continue...");
            Console.Read();
        }
    }
}
